DO $$
BEGIN
IF EXISTS (SELECT 1 FROM pg_type WHERE typname = 'rs_consulta_prod_equiv_prcliq') THEN
	DROP TYPE rs_consulta_prod_equiv_prcliq cascade;
END IF;
END$$;


CREATE TYPE rs_consulta_prod_equiv_prcliq AS
   (
	cd_prod integer,
	ds_prod character varying(250),
	vlr_tabela numeric(14, 2),
	vlr_liquido numeric(14, 2),
	ds_apres character varying,
	ds_arv_merc_equi character varying,
	qt_est integer,
	nm_fabric character varying,
	ds_sigla_linha character varying,
	vlr_custo numeric(14, 2),
	ordem integer
	 );
	
ALTER TYPE rs_consulta_prod_equiv_prcliq
  OWNER TO postgres;



/*
DROP FUNCTION public.p_consulta_produto_equiv_preco_liq(
    integer,			-- cd filial
    integer,			-- cd produto	
	integer				-- mesma pres  ???   usa CD_APRES no join EST_PROD_EST_ARV_MERCADOLOGICA
	integer,			-- cd conv
	character varying,  -- nro cartao fidelidade
	integer,			-- flag ean
	integer,			-- cd cli
	double precision,	-- qtde
	integer,			-- application
	double precision,	-- id promo
	integer,			-- is receita
	integer,			-- cd forma pgto
	integer,			-- cd vend
	integer,			-- cd parceiro
	integer				-- id propz
	)
*/

CREATE OR REPLACE FUNCTION public.p_consulta_produto_equiv_preco_liq(
    integer,			-- cd filial
    integer,			-- cd produto	
	integer,			-- mesma pres  ???   usa CD_APRES no join EST_PROD_EST_ARV_MERCADOLOGICA
	integer,			-- cd conv
	character varying,  -- nro cartao fidelidade
	integer,			-- flag ean
	integer,			-- cd cli
	double precision,	-- qtde
	integer,			-- application
	double precision,	-- id promo
	integer,			-- is receita
	integer,			-- cd forma pgto
	integer,			-- cd vend
	integer,			-- cd parceiro
	integer				-- id propz
	)
  RETURNS SETOF rs_consulta_prod_equiv_prcliq AS   
$BODY$
DECLARE
		in_cd_filial		ALIAS for $1;
		in_cd_prod			ALIAS for $2;
		in_mesma_pres		ALIAS for $3;
		in_cd_conv			ALIAS for $4;
		in_nr_cartao_fidel	ALIAS for $5;
		in_ean		  		ALIAS for $6;
		in_cd_cli		 	ALIAS for $7;
		in_qtde_prod		ALIAS for $8;
		in_application		ALIAS for $9;
		in_id_promo			ALIAS for $10;
		in_is_receita		ALIAS for $11;
		in_cd_frm_pgto		ALIAS for $12;
		in_cd_vend			ALIAS for $13;
		in_cd_parceiro		ALIAS for $14;
		in_propz_ident		ALIAS for $15;
		var_cd_prod           	integer;
		is_ctr_custo_semafaro   integer;
BEGIN

--select * from p_consulta_produto_equiv_preco_liq(18 , 156955 , 1 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0)
--select * from p_consulta_produto_equiv_preco_liq(18 , 156955 , 0 , 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0)       


	is_ctr_custo_semafaro = COALESCE((SELECT CAST(COALESCE(VALOR, '0') AS integer) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CTR_CUSTO_SEMAFORO'),0);

	BEGIN
		CREATE TEMPORARY TABLE temp_cods_produto
		(   -- valores de consulta unica
			cd_prod integer	
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_cods_produto; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.	
	END;
	
	
	BEGIN
		CREATE TEMPORARY TABLE temp_resultado	
		   (
			cd_prod integer,
			ds_prod character varying(250),
			vlr_tabela numeric(14, 2),
			vlr_liquido numeric(14, 2),
			ds_apres character varying,
			ds_arv_merc_equi character varying,
			qt_est integer,
			nm_fabric character varying,
			ds_sigla_linha character varying,
			vlr_custo numeric(14, 2),
			ordem integer
			 );
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_resultado; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.	
	END;	

	BEGIN
		CREATE TEMPORARY TABLE temp_rs_produto_pool
		(
			versao character varying(16),
			cd_emp integer,
			cd_filial integer,
			cd_prod integer,
			ds_prod character varying(100),
			nm_fabric character varying(100),
			vlr_tabela numeric(14,2),
			vlr_oferta numeric(14,2),
			qtde_ponto_fidel numeric(14,2),
			ctr_pmc integer,
			flag_verba_descon integer,
			flag_requer_receit integer,
			flag_alterar_preco integer,
			prod_uso_cont integer,
			tp_prod integer,
			vlr_custo numeric(14,2),
			cd_grp integer,
			qtd_ponto_venda double precision,
			lmt_prod_ponto_venda double precision,
			apres_qt_vd integer,
			qtde_estoque numeric(14,4),
			ds_tipo_receita character varying(100),
			ds_cor_receita character varying(100),
			perc_desc_limite numeric(14,4),
			cd_trib_fc character varying(3),
			perc_icms_n_cont_esta double precision,
			perc_red_vd double precision,
			libera_vd_conv integer,
			qtde_prod_max_conv integer,
			perc_desc_fix integer,
			tp_desconto integer,
			vlr_economia numeric(14,2),
			ds_desconto character varying(255),
			cd_tbl_desc integer,
			tp_nivel integer,
			perc_desc numeric(14,4),
			maior_perc_desc numeric(14,4),
			produto_controlado integer,
			flag_desconto_ticket_blq integer,
			perc_desc_fidel_max numeric(14,4),
			promo_industria integer,
			perc_desc_aniver numeric(14,4),
			perc_desc_clas numeric(14,4),
			vlr_desc_fabric numeric(14,2),
			campanha integer,
			qtde_prod_campanha integer,
			flag_bloqueia_desconto integer,
			perc_desc_pos_pbm double precision,
			cd_familia integer,
			ncm_prod character varying(50),
			nr_reg_ms character varying(150),
			qtde_limite_venda integer,
			perc_pis numeric(14,4),
			perc_cofins numeric(14,4),
			ds_categoria character varying(200),
			ds_sub_categoria character varying(200),
			unidade_medida character varying(100),
			tp_tbl_desc integer,
			dt_fim timestamp without time zone,
			qtde_limite_venda_familia integer,
			ds_familia character varying(255));	

		EXCEPTION WHEN OTHERS THEN TRUNCATE TABLE temp_rs_produto_pool; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;

			
				
	IF COALESCE((SELECT CAST(COALESCE(VALOR, '0') as integer) FROM PRC_EMP_CONFIG WHERE CD_CHAVE='FLAG_TIPO_PESQUISA_EQUIVALENCIA'), 0) <> 0
		THEN
		
			INSERT INTO temp_cods_produto
			SELECT EP_CONS.CD_PROD
				FROM   EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO
					   INNER JOIN EST_PROD AS EP_RETORNO
							   ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP
								  AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD
					   INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS
							   ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP
								  AND (	( in_mesma_pres = 1 and EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES  )
										OR ( in_mesma_pres = 0 )	)
								  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI
					   INNER JOIN EST_PROD AS EP_CONS
							   ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP
								  AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD
								  AND EPEAM_CONS.CD_APRES > 0
								  AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0
								  AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD
					   INNER JOIN EST_PROD_CPL AS EPL
							   ON EPL.CD_EMP = EP_RETORNO.CD_EMP
							   AND EPL.CD_FILIAL = in_cd_filial
								  AND EPL.CD_PROD = EP_RETORNO.CD_PROD
				WHERE  ( EPL.CD_FILIAL = in_cd_filial )
					   AND ( EP_CONS.CD_PROD = in_cd_prod )	
					   AND EP_CONS.CD_EMP = 1
					   AND EP_CONS.STS_PROD in ( 0 , 2 )
                  AND EPL.TP_PROD IN (0,9,10,11);
					   
	
	ELSE	

		INSERT INTO temp_cods_produto
		SELECT distinct prod.CD_PROD
			FROM   est_prod AS prod
				   INNER JOIN est_prod_princ_ativos_est_prod AS prin_ativo_ret
						   ON prod.cd_emp = prin_ativo_ret.cd_emp
							  AND prod.cd_prod = prin_ativo_ret.cd_prod
				   INNER JOIN est_prod_princ_ativos AS prin_ativo
						   ON prin_ativo_ret.cd_princ_ativos = prin_ativo.cd_princ_ativos
				   INNER JOIN est_prod_princ_ativos_est_prod AS prin_ativo_prod_cons
						   ON prin_ativo.cd_princ_ativos = prin_ativo_prod_cons.cd_princ_ativos
							  AND prin_ativo_prod_cons.cd_prod <> prin_ativo_ret.cd_prod
				   INNER JOIN est_prod_cpl AS prod_cpl
						   ON prod_cpl.cd_emp = prod.cd_emp
							  AND prod_cpl.cd_filial = in_cd_filial
							  AND prod_cpl.cd_prod = prod.cd_prod
			WHERE  ( prin_ativo_prod_cons.cd_prod = in_cd_prod )
				   AND ( prod_cpl.cd_filial = in_cd_filial )	
				   AND prod.CD_EMP = 1
				   AND prod.STS_PROD in ( 0 , 2 )
               AND prod_cpl.TP_PROD IN (0,9,10,11);
				
	END IF;

	-----------------PROCESSAMENTO DA PROCEDURE------------------------------------------------

	while exists (  select 1 from temp_cods_produto order by cd_prod limit 1  )  loop

		var_cd_prod = (select cd_prod from temp_cods_produto order by cd_prod  limit 1); 

		insert into temp_rs_produto_pool
		--select * from p_est_prod_descontos(1, in_cd_filial, var_cd_prod, 0, '0', 0, 0, 1, 0, 0, 0, 1, 0, 0);
		select * from p_est_prod_descontos(1, in_cd_filial, var_cd_prod, in_cd_conv, in_nr_cartao_fidel, in_ean
							, in_cd_cli, in_qtde_prod, in_application, in_id_promo, in_is_receita, in_cd_frm_pgto, in_cd_vend, in_cd_parceiro,in_propz_ident);

		delete from temp_cods_produto
		where cd_prod = var_cd_prod;

	end loop;


	IF COALESCE((SELECT CAST(COALESCE(VALOR, '0') as integer) FROM PRC_EMP_CONFIG WHERE CD_CHAVE='FLAG_TIPO_PESQUISA_EQUIVALENCIA'), 0) <> 0  THEN
	
		insert into temp_resultado 
		SELECT distinct  CAST(EP_RETORNO.CD_PROD AS INTEGER) as CD_PROD,
			   EP_RETORNO.DS_PROD,
			   CAST(EPP.VLR_TABELA AS numeric( 14, 2)) as VLR_TABELA,
				CAST( COALESCE(EPP.VLR_TABELA,0.00)
						- (COALESCE(EPP.VLR_TABELA,0.00)*(t.PERC_DESC/100.00) ) AS numeric(14, 2))  AS VLR_LIQUIDO,
			   EAMA.DS_APRES,
			   EAME.DS_ARV_MERC_EQUI,
			   CAST(EPL.QT_EST AS INTEGER ) as QT_EST,
			   EPF.NM_FABRIC,
			   EAML.DS_SIGLA_LINHA,
			   (SELECT CASE is_ctr_custo_semafaro
						 WHEN 0 THEN VLR_CUSTO
						 ELSE VLR_CUSTO_MD
					   END
				FROM   EST_PROD_CPL
				WHERE  CD_EMP = 1
					   AND CD_FILIAL = in_cd_filial
					   AND CD_PROD = EP_RETORNO.CD_PROD) AS VLR_CUSTO,
				0 as ordem
		FROM   temp_rs_produto_pool  t 
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO
				ON EPEAM_RETORNO.CD_EMP  = t.CD_EMP
				AND EPEAM_RETORNO.CD_PROD = t.CD_PROD
			   INNER JOIN EST_PROD AS EP_RETORNO
					   ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP
						  AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD
			   INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS
					   ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP
						  AND (	( in_mesma_pres = 1 and EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES  )
								OR ( in_mesma_pres = 0 )	)
						  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI
			   INNER JOIN EST_PROD AS EP_CONS
					   ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP
						  AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD
						  AND EPEAM_CONS.CD_APRES > 0
						  AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0
						  AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD
			   INNER JOIN EST_PROD_CPL AS EPL
					   ON EPL.CD_EMP = EP_RETORNO.CD_EMP
					   AND EPL.CD_FILIAL = in_cd_filial
						  AND EPL.CD_PROD = EP_RETORNO.CD_PROD
			   INNER JOIN EST_PROD_PRECO AS EPP
					   ON EPL.CD_EMP = EPP.CD_EMP
						  AND EPL.CD_FILIAL = EPP.CD_FILIAL
						  AND EPL.CD_PROD = EPP.CD_PROD
			   INNER JOIN EST_ARV_MERC_EQUIVALENTE AS EAME
					   ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP
						  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI
			   INNER JOIN EST_ARV_MERC_APRESENTACAO AS EAMA
					   ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP
						  AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES
			   INNER JOIN EST_PROD_FABRIC AS EPF
					   ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC
			   INNER JOIN EST_ARV_MERC_LINHA AS EAML
					   ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP
						  AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA ;
	
	ELSE
	
		insert into temp_resultado
		SELECT distinct  CAST( prod.cd_prod AS INTEGER) as cd_prod,
			   prod.ds_prod,
			   CAST(preco.vlr_tabela as numeric(14, 2)) as vlr_tabela,
				CAST( COALESCE(preco.VLR_TABELA,0.00)
							- (COALESCE(preco.VLR_TABELA,0.00)*(t.PERC_DESC/100.00) ) AS numeric(14, 2) )  AS vlr_liquido,
			   CAST('' as character varying)             AS ds_apres,
			   prin_ativo.ds_princ_ativos          AS ds_arv_merc_equi,
			   CAST(prod_cpl.qt_est as integer) as qt_est,
			   prod_fabric.nm_fabric,
			   est_arv_merc_linha.ds_sigla_linha,
			   (SELECT CASE is_ctr_custo_semafaro
						 WHEN 0 THEN vlr_custo
						 ELSE vlr_custo_md
					   END
				FROM   est_prod_cpl
				WHERE  cd_emp = 1
					   AND cd_filial = in_cd_filial
					   AND cd_prod = prod.cd_prod) AS vlr_custo,
				0 as ordem
		FROM  temp_rs_produto_pool  t 
			INNER JOIN est_prod AS prod
				ON prod.CD_PROD  = t.CD_PROD
				AND prod.CD_EMP = t.CD_EMP
			   INNER JOIN est_prod_princ_ativos_est_prod AS prin_ativo_ret
					   ON prod.cd_emp = prin_ativo_ret.cd_emp
						  AND prod.cd_prod = prin_ativo_ret.cd_prod
			   INNER JOIN est_prod_princ_ativos AS prin_ativo
					   ON prin_ativo_ret.cd_princ_ativos = prin_ativo.cd_princ_ativos
			   INNER JOIN est_prod_princ_ativos_est_prod AS prin_ativo_prod_cons
					   ON prin_ativo.cd_princ_ativos = prin_ativo_prod_cons.cd_princ_ativos
						  AND prin_ativo_prod_cons.cd_prod <> prin_ativo_ret.cd_prod
			   INNER JOIN est_prod_cpl AS prod_cpl
					   ON prod_cpl.cd_emp = prod.cd_emp
					   AND prod_cpl.cd_filial = in_cd_filial
						  AND prod_cpl.cd_prod = prod.cd_prod
			   INNER JOIN est_prod_preco AS preco
					   ON prod_cpl.cd_emp = preco.cd_emp
						  AND prod_cpl.cd_filial = preco.cd_filial
						  AND prod_cpl.cd_prod = preco.cd_prod
			   INNER JOIN est_prod_fabric AS prod_fabric
					   ON prod.cd_fabric = prod_fabric.cd_fabric
			   INNER JOIN est_prod_est_arv_mercadologica AS prod_arv_merc
					   ON prod.cd_emp = prod_arv_merc.cd_emp
						  AND prod.cd_prod = prod_arv_merc.cd_prod
			   INNER JOIN est_arv_merc_linha
					   ON prod_arv_merc.cd_arv_merc_linha = est_arv_merc_linha.cd_arv_merc_linha
						  AND prod_arv_merc.cd_emp = est_arv_merc_linha.cd_emp;

	END IF;

	return QUERY
		select 
			cd_prod,
			ds_prod ,
			vlr_tabela ,
			vlr_liquido ,
			ds_apres,
			ds_arv_merc_equi,
			qt_est ,
			nm_fabric ,
			ds_sigla_linha,
			vlr_custo ,
			ordem 	
		from temp_resultado
		order by vlr_liquido, qt_est DESC ;
		
END;

-- fim bloco principal
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 10
  ROWS 1000;
ALTER FUNCTION public.p_consulta_produto_equiv_preco_liq(
    integer,			-- cd filial
    integer,			-- cd produto	
	integer,			-- mesma pres  ???   usa CD_APRES no join EST_PROD_EST_ARV_MERCADOLOGICA
	integer,			-- cd conv
	character varying,  -- nro cartao fidelidade
	integer,			-- flag ean
	integer,			-- cd cli
	double precision,	-- qtde
	integer,			-- application
	double precision,	-- id promo
	integer,			-- is receita
	integer,			-- cd forma pgto
	integer,			-- cd vend
	integer,			-- cd parceiro
	integer				-- id propz
)
  OWNER TO postgres;
